#************************************************************************************
#                                                                                                  
#                                 Ex. DS3231.py                                       
#                                                                                                  
#************************************************************************************
#                                                                                                  
#  Board MCU   : RASPBERRY PI 3 MODEL B                                                         
#  Editor-IDE  : Geany 1.29                                                                       
#  Target Board Interface : ET-IOT HAT                                                     
#                                                                                                                                                                                                                                             
#************************************************************************************

import smbus
import time

#--- Open I2C interface ---
bus = smbus.SMBus(1) 	# use Port i2c-1

#--- Define I2C Address of RTC-DS3231 ---
RTC_ADDR  = 0x68 		# RTC DS3231 I2C device address

#--- Define RTC Address ---
Adr_Secon  	= 0x00
Adr_Minut   = 0x01
Adr_Hour    = 0x02

Adr_Day     = 0x03
Adr_Date    = 0x04
Adr_Mont    = 0x05
Adr_Year    = 0x06

#--- Define Valiable keep value RTC ----
Hour  = 0
Minut = 0
Sec   = 0

Date = 0
Mont = 0
Year = 0

    
#---------------------------------------
#           Function-Delay
#---------------------------------------
# dy = value delay unit (ms)
#---------------------------------------
def delay_ms(dy):
	time.sleep(dy/1000.0)


#****************** RTC FUNCTION *********************

#----------------------------------------------
#            Function-RTC Write 
#----------------------------------------------
# addr = address time rtc 0x00-0x0D
# byte = data time(0-59) or date(1-31)
#-----------------------------------------------
def rtc_write(addr,byte):
	byte = int2bcd(byte)
	bus.write_byte_data(RTC_ADDR,addr,byte)  # Write I2C Address of RTC,address-RTC, and data
 

#----------------------------------------------
#            Function-RTC Read 
#----------------------------------------------
# addr = address time rtc 0x00-0x12
#----------------------------------------------
def rtc_read(addr):
	dd = bus.read_byte_data(RTC_ADDR,addr)  # Read rtc data
	return bcd2int(dd)
	
	
#----------------------------------------------
#     Function-Convert Number bcd to int
#----------------------------------------------
# bcd = value for convert
#----------------------------------------------
def bcd2int(bcd):
	n1 = bcd%16
	bcd2 = bcd-n1
	n2 = ((bcd2>>4)*10)
	return int(n1+n2)


#----------------------------------------------
#     Function-Convert Number int to bcd
#----------------------------------------------
# val = value for convert
#----------------------------------------------
def int2bcd(val):
	b1 = val%10
	val2 = val-b1
	b2 = (int(val2/10)<<4)
	return int(b1+b2)


#----------------------------------------------
#            Function-Set Time 
#----------------------------------------------
# hh = Set value Hour   0-23 (Decimal)
# mn = Set value Minute 0-59 (Decimal)
# ss = Set value Second 0-59 (Decimal)
#-----------------------------------------------
def Set_Time(hh,mn,ss):
	rtc_write(Adr_Hour,hh)      # Write Hour  Decimal to RTC
	rtc_write(Adr_Minut,mn)     # Write Minut Decimal to RTC
	rtc_write(Adr_Secon,ss)     # Write Secon Decimal to RTC
   

#----------------------------------------------
#            Function-Read Time 
#----------------------------------------------
# Read Hour,Minute,Second :Data = Decimal
#-----------------------------------------------
def Read_Time():
    
	global Hour  
	global Minut 
	global Sec
    
	Hour  = rtc_read(Adr_Hour)    # Read Hour   Decimal From RTC
	Minut = rtc_read(Adr_Minut)   # Read Minute Decimal From RTC
	Sec   = rtc_read(Adr_Secon)   # Read Second Decimal From RTC


#----------------------------------------------
#       Function-Display Time to screen 
#----------------------------------------------
# 
#-----------------------------------------------
def Show_Time():
	print ("Time: %02d:%02d:%02d" %(Hour,Minut,Sec)) 

    
#----------------------------------------------
#      Function-Set Date/Month/Year
#----------------------------------------------
# dd = Set value Date of Month  1-31 (Decimal)
# mm = Set value Month 1-12 (Decimal)
# yy = Set value year 00-99 (Decimal-A.D.)
#-----------------------------------------------
def Set_Date(dd,mm,yy):
	rtc_write(Adr_Date,dd)     # Write Date  Decimal to RTC
	rtc_write(Adr_Mont,mm)     # Write Month Decimal to RTC
	rtc_write(Adr_Year,yy)     # Write Year  Decimal to RTC

#----------------------------------------------
#       Function-Read Date/Month/Year 
#----------------------------------------------
# Read Date,Month,Year :Data = Decimal
#-----------------------------------------------
def Read_Date():
    
	global Date  
	global Mont 
	global Year
    
	Date   = rtc_read(Adr_Date)    # Read Date  Decimal From RTC
	Mont   = rtc_read(Adr_Mont)    # Read Month Decimal From RTC
	Year   = rtc_read(Adr_Year)    # Read Year  Decimal From RTC


#----------------------------------------------
#       Function-Display Date to screen 
#----------------------------------------------
# Year is A.D.
#-----------------------------------------------
def Show_Date():
	print ("Date: %02d/%02d/20%02d" %(Date,Mont,Year)) 


#************************ END-RTC ***********************

Set_Time(12,0,0)  # Set Time 12:00:00
Set_Date(29,9,16) # Set Date 29/09/2016
 
while True:
	Read_Time()
	Read_Date()

	Show_Time()
	Show_Date()
   
	print(" ")
   
	delay_ms(1000)





